<!DOCTYPE html>
<html>

<head>
    <title>How to use? | STFMS</title>

    <!--Meta tags start-->
    <meta charset="UTF-8">
    <meta name="description" content="Smart Traffic Fine Management System for Sri Lanka">
    <meta name="keywords" content="Traffic, Fine, System, Sri Lanka">
    <meta name="author" content="Uva Wellassa University">
    <meta name="viewport" content="width=device-width, height=device-height, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0">
    <!--Meta tags end-->

    <!--Favicon start-->
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    <!--Favicon end-->


    <!-- Import lib -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/animatecss/animate.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap/bootstrap.min.css">
    <!-- End import lib -->
    <!-- Import fonts -->
    <script src='https://kit.fontawesome.com/a076d05399.js'></script>
    <link href="https://fonts.googleapis.com/css?family=Baloo+Chettan|Dosis:400,600,700|Poppins:400,600,700&display=swap" rel="stylesheet" />
    <!-- End fonts -->
    <!-- Import styles -->
    <link rel="stylesheet" type="text/css" href="assets/css/main.css">
    <link rel="stylesheet" type="text/css" href="assets/css/home.css">
    <!-- End styles -->
    <!-- Import fontawesome from CDN -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
    <!-- End fontawesome from CDN -->

    <style>
        body{
            background-color: #234a7a;
        }
    </style>

</head>

<body class="overlay-scrollbar">
    <!--==================================================================================================================================SECTION_01====================================================================================================================================-->

    <!-- Topbar navigation start here ===================================================-->
    <div class="topnavbar animated fadeIn">
        <!-- topnav left -->
        <ul class="topnavbar-nav">
            <li class="topnav-item">
                <a href="index.php"><img src="assets/img/logo_text.svg" alt="STFMS logo" class="logo logo-light"></a>
            </li>
        </ul>
        <!-- end topnav left -->
        <!-- topnav right -->
        <ul class="topnavbar-nav topnav-right">
            <li class="topnav-item">
                <div class="mydropdown">
                    <p class="mt-3 mr-4">
                        <a href="user/login.php"><span class="btn btn-md btn-danger" data-toggle="modal" data-target="#userLogdin">Log In <i class="fas fa-sign-in-alt" style="font-size: 1rem;"></i></span></a>
                    </p>
                </div>
            </li>
        </ul>
        <!-- end topnav right -->
    </div>
    <!-- Topbar navigation end here ===================================================-->


    <!--==================================================================================================================================SECTION_02====================================================================================================================================-->

    <div class="container-fluid" style="margin-top: 100px; padding: 0 4rem 3rem 4rem;">
        <h1 class="heading">How to use STFMS?</h1>
        <hr></hr>
        <div class="row animated fadeIn delay-1s" style="margin-bottom: 4.5rem; margin-top: 4rem;">
            <div class="col-md-6">
                <h2 class="heading">01. Login and dashboard overview</h2>
                <p class="para animated fadeInDown delay-750ms">You can log in to the system using the login details we have provided. If login details are correct you will redirect to the Dashboard. You can search paid and pending fines. We keep track of every record from the beginning. You can get idea by looking at the dashboard which has your all records with many analyzed ways.</p>
            </div>
            <div class="col-md-6">
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe width="600" height="380" src="https://www.youtube.com/embed/t4rLrI9GoFY" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> 
                </div>        
            </div>
        </div>
        <div class="row animated fadeIn delay-1s">
            <div class="col-md-6">
                <h2 class="heading">02. How to pay fine online?</h2>
                <p class="para animated fadeInDown delay-750ms">You can pay fine with online system. In pending fine details, there is a option called 'Pay Now'. Click it and you can proceed your payments through online.</p>
            </div>
            <div class="col-md-6" style="margin-bottom: 4.5rem;">
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe width="600" height="380" src="https://www.youtube.com/embed/AdZ9D-_qFSc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> 
                </div>
            </div>
        </div>
        <div class="row animated fadeIn delay-1s" style="margin-bottom: 4.5rem;">
            <div class="col-md-6">
                <h2 class="heading">03. How to change your password?</h2>
                <p class="para animated fadeInDown delay-750ms">Once you log in to the system, you can see the "Setting" button In the upper right corner. Click it and select the "Edit Profile" button. Now you can change your password using default login detail we have provided.</p>
            </div>
            <div class="col-md-6">
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe width="600" height="380" src="https://www.youtube.com/embed/VqNYSj4ueCQ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> 
                </div>
            </div>
        </div>
        <div class="row animated fadeIn delay-1s">
            <div class="col-md-6">
                <h2 class="heading">04. How to reset your password?</h2>
                <p class="para animated fadeInDown delay-750ms">If forget password, you can change your password using forget password option. Click "forget password" and enter the email address we have provided. Then, the system will send a code to your email. If code is received, copy it and paste the code correctly. Now you can change your password as you wish.</p>
            </div>
            <div class="col-md-6" style="margin-bottom: 4.5rem;">
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe width="600" height="380" src="https://www.youtube.com/embed/hoPrOwfZ8DM" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> 
                </div>
            </div>
        </div>
    </div>

    <!--==================================================================================================================================SECTION_03====================================================================================================================================-->
        <!-- Footer start from here-->
        <footer class="footer" style="background-color: #0f3057;">
            <div class="container animated fadeIn">
                <div class="row">
                    <div class="footer-col">
                        <h4>Inquiry via telephone</h4>
                        <ul>
                            <li><a href="tel:+94714590248"><i class="fas fa-phone"></i> +00 0000000000</a></li>
                        </ul>
                    </div>
                    <div class="footer-col">
                        <h4>Inquiry via email</h4>
                        <ul>
                            <li><a style="text-transform: lowercase;" href="#" target="_blank"> <i class="fas fa-envelope"></i> example@gmail.com</a></li>
                        </ul>
                    </div>
                    <div class="footer-col">
                        <h4>Get help</h4>
                        <ul>
                            <li><a href="help.php">How to use?</a></li>
                        </ul>
                        <ul>
                            <li><a href="gov.php">Government Log in</a></li>
                        </ul>
                    </div>
                    <div class="footer-col">
                        <img class="footer-logo" src="assets/img/footer_logo.svg">
                    </div>
                </div>
            </div>
        </footer>
        <!-- Footer End from here-->


    <!--==================================================================================================================================JS_FILES======================================================================================================================================-->
    <script src="//code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script type="text/javascript" language="javascript" src="assets/vendors/bootstrap/popper.min.js"></script>
    <script type="text/javascript" language="javascript" src="assets/vendors/jquery/jquery-3.5.1.js"></script>
    <script type="text/javascript" language="javascript" src="assets/vendors/bootstrap/bootstrap.min.js"></script>



</body>

</html>